'***********************************
'* Connection matrix
'* Pos0 = I1=x I2=x I3=x
'* Pos1 = In1=Out1 In2=Out2 In3=Out3 (default = powerless Relais)
'* Pos2 = In1=Out1 In2=Out3 In3=Out2
'* Pos3 = In1=Out2 In2=Out1 In3=Out3
'* Pos4 = In1=Out2 In2=Out3 In3=Out1
'* Pos5 = In1=Out3 In2=Out1 In3=Out2
'* Pos6 = In1=Out3 In2=Out2 In3=Out1
'*
'* In1 => Out1 = K4, K1 = off
'* In1 => Out2 = K2, K4, K6
'* In1 => Out3 = K3, K4
'*
'* In2 => Out1 = K1, K5, K9
'* In2 => Out2 = K9, K11, K7, K2 = off
'* In2 => Out3 = K8, K11
'*
'* In3 => Out1 = K1, K5
'* In3 => Out2 = K7, K12
'* In3 => Out3 = K10, K12, K8, K3 = off
'*
'***********************************

Sub SetRelais(ByVal n As Integer , ByVal p As Integer)
  Select Case n
    Case 1
      K1 = p
    Case 2
      K2 = p
    Case 3
      K3 = p
    Case 4
      K4 = p
    Case 5
      K5 = p
    Case 6
      K6 = p
    Case 7
      K7 = p
    Case 8
      K8 = p
    Case 9
      K9 = p
    Case 10
      K10 = p
    Case 11
      K11 = p
    Case 12
      K12 = p
  End Select
End Sub

Sub SetConfig(ByVal n As Integer)
  Select Case n
    Case 0
      Call SetNoConnection

    Case 1
      Call SetIn1Out1
      Call SetIn2Out2
      Call SetIn3Out3

    Case 2
      Call SetIn1Out2
      Call SetIn2Out1
      Call SetIn3Out3

    Case 3
      Call SetIn1Out3
      Call SetIn2Out2
      Call SetIn3Out1

    Case 4
      Call SetIn1Out1
      Call SetIn2Out3
      Call SetIn3Out2

    Case 5
      Call SetIn1Out2
      Call SetIn2Out3
      Call SetIn3Out1

    Case 6
      Call SetIn1Out3
      Call SetIn2Out1
      Call SetIn3Out2

  End Select
End Sub

Sub SetIn1Out1
  Call SetRelais(1 , 0)
  Call SetRelais(4 , 0)
  LED_O1_I1 = true
End Sub

Sub SetIn1Out2
  Call SetRelais(2 , 1)
  Call SetRelais(4 , 1)
  Call SetRelais(6 , 1)
  LED_O2_I1 = true
End Sub

Sub SetIn1Out3
  Call SetRelais(3 , 1)
  Call SetRelais(4 , 1)
  LED_O3_I1 = true
End Sub

Sub SetIn2Out1
  Call SetRelais(1 , 1)
  Call SetRelais(5 , 1)
  Call SetRelais(9 , 1)
  LED_O1_I2 = true
End Sub

Sub SetIn2Out2
  Call SetRelais(2 , 0)
  Call SetRelais(7 , 0)
  Call SetRelais(9 , 0)
  Call SetRelais(11 , 0)
  LED_O2_I2 = true
End Sub

Sub SetIn2Out3
  Call SetRelais(3 , 0)
  Call SetRelais(8 , 1)
  Call SetRelais(9 , 0)
  Call SetRelais(11 , 1)
  LED_O3_I2 = true
End Sub

Sub SetIn3Out1
  Call SetRelais(1 , 1)
  Call SetRelais(10 , 1)
  LED_O1_I3 = true
End Sub

Sub SetIn3Out2
  Call SetRelais(2 , 0)
  Call SetRelais(7 , 1)
  Call SetRelais(10 , 0)
  Call SetRelais(12 , 1)
  LED_O2_I3 = true
End Sub

Sub SetIn3Out3
  Call SetRelais(3 , 0)
  Call SetRelais(8 , 0)
  Call SetRelais(10 , 0)
  Call SetRelais(12 , 0)
  LED_O3_I3 = true
End Sub

Sub SetNoConnection
  'No connections
  Call SetRelais(3 , 0)
  Call SetRelais(4 , 0)
  Call SetRelais(5 , 0)
  Call SetRelais(6 , 0)
  Call SetRelais(7 , 0)
  Call SetRelais(9 , 0)
  Call SetRelais(10 , 0)
  Call SetRelais(11 , 0)
  Call SetRelais(12 , 0)
  Call SetRelais(1 , 1)
  Call SetRelais(2 , 1)
  Call SetRelais(8 , 1)

  LED_O1_I1 = false
  LED_O1_I2 = false
  LED_O1_I3 = false

  LED_O2_I1 = false
  LED_O2_I2 = false
  LED_O2_I3 = false

  LED_O3_I1 = false
  LED_O3_I2 = false
  LED_O3_I3 = false
End Sub