'*********************************************
'* HF switch box AMS-33 from ELAD
'* modified firmware for remote control
'* using RS232 terminal => USB converter
'* HB9FZG 2016
'*
'* Connection matrix
'* Pos0 = I1=x I2=x I3=x
'* Pos1 = In1=Out1 In2=Out2 In3=Out3
'* Pos2 = In1=Out1 In2=Out3 In3=Out2
'* Pos3 = In1=Out2 In2=Out1 In3=Out3
'* Pos4 = In1=Out2 In2=Out3 In3=Out1
'* Pos5 = In1=Out3 In2=Out1 In3=Out2
'* Pos6 = In1=Out3 In2=Out2 In3=Out1
'*
'*********************************************

$regfile = "m169pdef.dat"
$crystal = 8000000
$hwstack = 16
$swstack = 32
$framesize = 32
$baud = 9600

CONFIG SUBMODE = NEW

CONST true = 1
CONST false = 0
CONST LEDPWR_ein = 0
CONST LEDPWR_aus = 1
CONST BUTTON_pressed = 0
CONST BUTTON_released = 1
CONST CMDnil = 0
CONST CMDstarted = 1
CONST CMDreceived = 2
CONST SleepDelay = 5
CONST POSnil = 255

LED_O1_I1 Alias PortA.3
LED_O1_I2 Alias PORTC.6
LED_O1_I3 Alias PORTC.7

LED_O2_I1 Alias PORTE.4
LED_O2_I2 Alias PORTE.3
LED_O2_I3 Alias PORTE.2

LED_O3_I1 Alias PORTE.7
LED_O3_I2 Alias PORTE.6
LED_O3_I3 Alias PORTE.5

BUTTON Alias PIND.1
LEDPWR Alias PORTB.1

K1 Alias PORTD.5
K2 Alias PORTC.0
K3 Alias PORTD.7
K4 Alias PORTD.2
K5 Alias PORTD.6
K6 Alias PORTC.4
K7 Alias PORTC.1
K8 Alias PORTC.3
K9 Alias PORTD.3
K10 Alias PORTD.4
K11 Alias PORTC.2
K12 Alias PORTC.5

DDRA = &b00001000
DDRB = &b00000010
DDRC = &b11111111
DDRD = &b11111100
DDRE = &b11111100

DIM Event10ms As Boolean
DIM Event100ms As Boolean
DIM Event1s As Boolean
DIM EventCntr As Integer
DIM Position_Curr As Integer
DIM E_Position_Curr as Eram Integer
DIM Position_New As Integer
DIM i As Integer
DIM x As Integer
DIM d as Byte
DIM cmdValue as Byte
DIM cmdState as Byte
DIM cmdLock as Integer
DIM Button_cntr as Integer
DIM Sleep_cntr as Integer

$include system.inc
$include relaispos.inc

'Init Timer0 (10ms cycle)
CONFIG TIMER0 = TIMER , PRESCALE = 1024
START TIMER0
ON OVF0 isrTimer0_Overflow
ENABLE OVF0

Config COM1 = 9600 , Synchrone = 0 , Parity = None , Stopbits = 1 , Databits = 8 , Clockpol = 0
Open "COM1:" For BINARY As #1
On URXC isrRX_DataReceived
Enable URXC

Config Int0 = LOW LEVEL
On Int0 isrINT0 NoSave

'Config PCINT0
Pcmsk0 = &B00000001
On PCINT0 isrPCINT0

ENABLE Interrupts
LEDPWR = LEDPWR_ein
cmdState = CMDnil
Position_Curr = POSnil
Position_New = E_Position_Curr
Sleep_cntr = SleepDelay

Do
  If Position_New <> Position_Curr Then
    ' Open all connections
    Call SetNoConnection
    Waitms 100
    Call SetConfig(Position_New)
    Position_Curr = Position_New
    Sleep_cntr = SleepDelay
  End If

  If Event10ms = true then
    Event10ms = false
    If cmdLock > 0 Then DECR cmdLock
    If Button = BUTTON_pressed Then
      INCR Button_cntr
    Else
      Select Case Button_cntr
        Case 10 to 50
          If Position_New < 6 Then
            INCR Position_New
          Else
            Position_New = 0
          End If
          Button_cntr = 0
        Case Is > 100
          ' do nothing now
            Button_cntr = 0
      End Select
    End If
  End If

  If Event100ms = true then
    Event100ms = false
  End If

  If Event1s = true then
    Event1s = false
    If Sleep_cntr > 0 Then
      DECR Sleep_cntr
    End If
  End If

  If Sleep_cntr = 0 Then
    Call goSleep
  End If
Loop

'ISRs

isrINT0:
  DISABLE INT0
  Sleep_cntr = SleepDelay
RETURN

isrPCINT0:
  Sleep_cntr = SleepDelay
RETURN

isrTimer0_Overflow:
  'set 10ms interval
  TIMER0 = 178
  Event10ms = true
  'Toggle LEDPWR
  Incr EventCntr
  Select Case EventCntr
    Case 10
      Event100ms = true
    Case 20
      Event100ms = true
    Case 30
      Event100ms = true
    Case 40
      Event100ms = true
    Case 50
      Event100ms = true
    Case 60
      Event100ms = true
    Case 70
      Event100ms = true
    Case 80
      Event100ms = true
    Case 90
      Event100ms = true
    Case 100
      EventCntr = 0
      Event1s = true
  End Select
RETURN

'COM1 data received
isrRX_DataReceived:
  d = UDR
  'Toggle LEDPWR
  Select Case d
    Case 35                                                 ' # Command Start received
      cmdState = CMDstarted

    Case 48 to 54                                           ' "0" - "6" = valid relais map positions received
      if cmdState = CMDstarted then
        cmdValue = d - 48                                   'shift the ascii gap
        cmdState = CMDreceived
      end if

    Case 13                                                 ' CR Command End received
      if cmdState = CMDreceived then
        if cmdLock = 0 then
          cmdLock = 100                                     ' set 1 second lock time
          Position_New = cmdValue
        end if
      end if
      cmdState = CMDnil

    Case 10
      'do nothing, just ignore the LF character

    Case else                                               ' invalid command payload
      cmdState = CMDnil

  End Select
RETURN